local t = Def.ActorFrame{}
local StagesPlayed = STATSMAN:GetStagesPlayed()

local function GetPlayedSongTitles(i)
	local pSS = STATSMAN:GetPlayedStageStats(i)
	local PlayedSongs = pSS:GetPlayedSongs()
	local Song = PlayedSongs[1]:GetDisplayFullTitle()
	return Song
end

local function GetPlayedSongBanner(i)
	local pSS = STATSMAN:GetPlayedStageStats(i)
	local PlayedSongs = pSS:GetPlayedSongs()
	local Song = PlayedSongs[1]:GetBannerPath()
	return Song
end

local function GetPlayedJudgment(pn,i,tns)
	local pSS = STATSMAN:GetPlayedStageStats(i)
	local plSS = pSS:GetPlayerStageStats(pn)
	local TNS = plSS:GetTapNoteScores(tns)
	return TNS
end

local function GetDifficultyColor(pn,i)
	local pSS = STATSMAN:GetPlayedStageStats(i)
	local plSS = pSS:GetPlayerStageStats(pn)
	local pSteps = plSS:GetPlayedSteps()
	local Step = pSteps[1]
	
	if Step == nil then
		return 'Difficulty_Edit'
	else
		Step = pSteps[1]
	end
	
	local Diff = Step:GetDifficulty()
	return Diff
end

t[#t+1] = Def.ActorFrame{
	BeginCommand=cmd(draworder,-1);
	Def.Quad{ -- #1
		InitCommand=cmd(x,CenterX();y,Top()+40;valign,0;zoomto,Width(),40;diffuse,Black();zwrite,true;blend,'BlendMode_NoEffect');
	};
};

-------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------

for i=1,StagesPlayed do
	local AbleToMoveDown = (round(StagesPlayed / 5))
	local AbleToMoveUp = 0
	t[#t+1] = Def.ActorFrame{
		BeginCommand=cmd(zwrite,true;ztest,true);
		CodeMessageCommand=function(self,param)
			if param.Name == "Up" then
				if AbleToMoveUp > 0 then
					self:smooth(1)
					self:addy(72*5)
					AbleToMoveUp = AbleToMoveUp - 1
					AbleToMoveDown = AbleToMoveDown + 1
				end
			end
			if param.Name == "Down" then
				if AbleToMoveDown > 0 then
					self:smooth(1)
					self:addy(-72*5)
					AbleToMoveDown = AbleToMoveDown - 1
					AbleToMoveUp = AbleToMoveUp + 1
				end
			end
		end;
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX();y,Top()+12+(72*i);valign,0;zoom,0.4;shadowlength,1;maxwidth,500;uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(GetPlayedSongTitles(i))
			end
		};
		LoadFont("Common Normal")..{
			Text="P1";
			InitCommand=cmd(x,Left()+68;y,Top()+12+(72*i);zoom,0.5;shadowlength,1;valign,0);
			OnCommand=cmd(visible,IsPlayerEnabled(PLAYER_1);diffusealpha,1;diffuse,GameColor.PlayerColors.PLAYER_1);
		};
		LoadFont("Common Normal")..{
			Text="P2";
			InitCommand=cmd(x,Right()-68;y,Top()+12+(72*i);zoom,0.5;shadowlength,1;valign,0);
			OnCommand=cmd(visible,IsPlayerEnabled(PLAYER_2);diffusealpha,1;diffuse,GameColor.PlayerColors.PLAYER_2);
		};
		Def.Quad{ -- #1
			InitCommand=cmd(draworder,-501;x,CenterX();y,Top()+8+(72*i);valign,0;zoomto,210,16;diffuse,Black();diffusealpha,0.8);
		};
		Def.Quad{ -- #1
			InitCommand=cmd(draworder,-1000;x,CenterX();y,Top()+8+(72*i);valign,0;zoomto,Width()-112,64;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2);diffusealpha,0.3);
		};
		Def.Sprite{
			InitCommand=cmd(draworder,-800;x,CenterX();y,Top()+8+(72*i);valign,0;scaletoclipped,210,64;playcommand,"Banner");
			BannerCommand=function(self)
				self:Load(GetPlayedSongBanner(i))
			end;
		};
		-- PLAYER 1
		LoadFont("Common Normal")..{
			Name="Grade";
			InitCommand=cmd(x,CenterX()-112-72*2;y,Top()+12+(72*i);align,1,0;zoom,0.5;shadowlength,1;maxwidth,500;uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(GetPlayedGrade(PLAYER_1,i))
				self:visible(IsPlayerEnabled(PLAYER_1))
			end
		};
		LoadFont("Common Normal")..{
			Name="Score";
			InitCommand=cmd(x,CenterX()-112-72*2;y,Top()+32+(72*i);align,1,0;zoom,0.5;shadowlength,1;maxwidth,500;uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(FormatPercentScore(GetPlayedScore(PLAYER_1,i)))
				self:visible(IsPlayerEnabled(PLAYER_1))
			end
		};
		LoadFont("Common Normal")..{
			Name="Difficulty";
			InitCommand=cmd(x,CenterX()-112-72*2;y,Top()+52+(72*i);align,1,0;zoom,0.5;shadowlength,1;maxwidth,500;uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				if IsPlayerEnabled(PLAYER_1) then
					self:settext(GetPlayedDifficulty(PLAYER_1,i))
					self:diffuse(CustomDifficultyToColor(GetDifficultyColor(PLAYER_1,i)))
				else
					self:visible(false)
				end
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()-112;y,Top()+12+(72*i);align,1,0;zoom,0.7;shadowlength,1;maxwidth,500;diffuse,color(jColors[1]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_1,i,9)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_1,i,9); Diffuse = ColorDarkTone(color(jColors[1])) } )
				self:visible(IsPlayerEnabled(PLAYER_1))
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()-112;y,Top()+32+(72*i);align,1,0;zoom,0.7;shadowlength,1;maxwidth,500;diffuse,color(jColors[2]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_1,i,8)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_1,i,8); Diffuse = ColorDarkTone(color(jColors[2])) } )
				self:visible(IsPlayerEnabled(PLAYER_1))
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()-112;y,Top()+52+(72*i);align,1,0;zoom,0.7;shadowlength,1;maxwidth,500;diffuse,color(jColors[3]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_1,i,7)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_1,i,7); Diffuse = ColorDarkTone(color(jColors[3])) } )
				self:visible(IsPlayerEnabled(PLAYER_1))
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()-112-72;y,Top()+12+(72*i);align,1,0;zoom,0.7;shadowlength,1;maxwidth,500;diffuse,color(jColors[4]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_1,i,6)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_1,i,6); Diffuse = ColorDarkTone(color(jColors[4])) } )
				self:visible(IsPlayerEnabled(PLAYER_1))
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()-112-72;y,Top()+32+(72*i);align,1,0;zoom,0.7;shadowlength,1;maxwidth,500;diffuse,color(jColors[5]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_1,i,5)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_1,i,5); Diffuse = ColorDarkTone(color(jColors[5])) } )
				self:visible(IsPlayerEnabled(PLAYER_1))
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()-112-72;y,Top()+52+(72*i);align,1,0;zoom,0.7;shadowlength,1;maxwidth,500;diffuse,color(jColors[6]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_1,i,4)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_1,i,4); Diffuse = ColorDarkTone(color(jColors[6])) } )
				self:visible(IsPlayerEnabled(PLAYER_1))
			end
		};
		-- PLAYER 2
		LoadFont("Common Normal")..{
			Name="Grade";
			InitCommand=cmd(x,CenterX()+112+72*2;y,Top()+12+(72*i);align,0,0;zoom,0.5;shadowlength,1;maxwidth,500;uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(GetPlayedGrade(PLAYER_2,i))
				self:visible(IsPlayerEnabled(PLAYER_2))
			end
		};
		LoadFont("Common Normal")..{
			Name="Score";
			InitCommand=cmd(x,CenterX()+112+72*2;y,Top()+32+(72*i);align,0,0;zoom,0.5;shadowlength,1;maxwidth,500;uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(FormatPercentScore(GetPlayedScore(PLAYER_2,i)))
				self:visible(IsPlayerEnabled(PLAYER_2))
			end
		};
		LoadFont("Common Normal")..{
			Name="Difficulty";
			InitCommand=cmd(x,CenterX()+112+72*2;y,Top()+52+(72*i);align,0,0;zoom,0.5;shadowlength,1;maxwidth,216;uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				if IsPlayerEnabled(PLAYER_2) then
					self:settext(GetPlayedDifficulty(PLAYER_2,i) or "PLAYER NOT PRESENT")
					self:diffuse(CustomDifficultyToColor(GetDifficultyColor(PLAYER_2,i)))
				else
					self:visible(false)
				end
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()+112;y,Top()+12+(72*i);align,0,0;zoom,0.7;shadowlength,1;maxwidth,500;diffuse,color(jColors[1]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_2,i,9)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_2,i,9); Diffuse = ColorDarkTone(color(jColors[1])) } )
				self:visible(IsPlayerEnabled(PLAYER_2))
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()+112;y,Top()+32+(72*i);align,0,0;zoom,0.7;shadowlength,1;maxwidth,500;diffuse,color(jColors[2]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_2,i,8)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_2,i,8); Diffuse = ColorDarkTone(color(jColors[2])) } )
				self:visible(IsPlayerEnabled(PLAYER_2))
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()+112;y,Top()+52+(72*i);align,0,0;zoom,0.7;shadowlength,1;maxwidth,500;diffuse,color(jColors[3]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_2,i,7)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_2,i,7); Diffuse = ColorDarkTone(color(jColors[3])) } )
				self:visible(IsPlayerEnabled(PLAYER_2))
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()+112+72;y,Top()+12+(72*i);align,0,0;zoom,0.7;shadowlength,1;maxwidth,500;diffuse,color(jColors[4]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_2,i,6)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_2,i,6); Diffuse = ColorDarkTone(color(jColors[4])) } )
				self:visible(IsPlayerEnabled(PLAYER_2))
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()+112+72;y,Top()+32+(72*i);align,0,0;zoom,0.7;shadowlength,1;maxwidth,500;diffuse,color(jColors[5]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_2,i,5)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_2,i,5); Diffuse = ColorDarkTone(color(jColors[5])) } )
				self:visible(IsPlayerEnabled(PLAYER_2))
			end
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(x,CenterX()+112+72;y,Top()+52+(72*i);align,0,0;zoom,0.7;shadowlength,1;maxwidth,500;diffuse,color(jColors[6]);uppercase,true;playcommand,"Song");
			SongCommand=function(self)
				self:settext(string.format("%04.f", GetPlayedJudgment(PLAYER_2,i,4)))
				self:AddAttribute( 0, { Length = LeadingToPlayedFourZeros(PLAYER_2,i,4); Diffuse = ColorDarkTone(color(jColors[6])) } )
				self:visible(IsPlayerEnabled(PLAYER_2))
			end
		};
	};
end

t[#t+1] = Def.ActorFrame{
	Def.Quad {
		InitCommand=cmd(xy,CenterX(),Bottom();valign,1;setsize,Width(),16;diffuse,Black());
	};
	Def.Quad {
		InitCommand=cmd(draworder,-1;x,CenterX();y,Bottom();valign,1;zoomto,Width(),40;diffuse,color(LoadFile("ThemeColor.cfg","Settings")));
	};
};

return t